<?php
// File: /includes/functions.php
// General helper functions

/**
 * Sanitize input data
 */
function clean($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

/**
 * Format money
 */
function formatMoney($amount) {
    return '$' . number_format($amount, 2);
}

/**
 * Redirect helper
 */
function redirect($url) {
    header("Location: $url");
    exit();
}

/**
 * Flash message helper (requires session)
 */
function setFlash($type, $message) {
    $_SESSION['flash'] = [
        'type' => $type, // 'success', 'danger', 'info'
        'message' => $message
    ];
}

function displayFlash() {
    if (isset($_SESSION['flash'])) {
        $type = $_SESSION['flash']['type'];
        $msg = $_SESSION['flash']['message'];
        echo "<div class='alert alert-{$type}'>{$msg}</div>";
        unset($_SESSION['flash']);
    }
}

/**
 * Log a transaction
 */
function logTransaction($pdo, $user_id, $type, $amount, $description) {
    $stmt = $pdo->prepare("INSERT INTO transactions (user_id, type, amount, description) VALUES (?, ?, ?, ?)");
    $stmt->execute([$user_id, $type, $amount, $description]);
}
?>
